//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.1
import QtGraphicalEffects 1.0

import wesual.Controls 1.0

FocusScope {
    id : dropdownButton

    property list<Action> actions
    property int   currentIndex  : -1
    property int   buttonBorder  : 0
    property color buttonColor   : UI.color(UI.PrimaryBase)
    property alias buttonText    : openPopupAction.text
    property alias buttonIconSource : openPopupAction.iconSource
    property alias showIndicator : indicator.visible

    readonly property bool open : popup.popupVisible

    function openPopup()  {
        popup.show();
    }

    // Key handling
    Keys.onSpacePressed : {
        if (!popup.visible) {
            dropdownButton.openPopup();
        }
    }

    implicitHeight : toolButton.height
    implicitWidth  : toolButton.width + indicator.width
    z : popup.visible ? 10000 : 0

    ToolButton {
        id : toolButton

        activeFocusOnTab : true
        color : {
            if (ma.pressed || open)
                return UI.color(UI.PrimaryPress);
            else if (ma.containsMouse || activeFocus)
                return UI.color(UI.PrimaryHover);
            else
                return UI.color(UI.PrimaryBase);
        }

        action : Action {
            id   : openPopupAction
            iconSource : "qrc:/controls/icons/add.png"
            onTriggered : dropdownButton.openPopup()
        }
    }
    Rectangle {
        id : indicator

        anchors.left : toolButton.right
        height : parent.height
        width  : 15
        color  : toolButton.color

        ColorizedImage {
            id : image
            anchors.verticalCenter : parent.verticalCenter
            source : "qrc:/controls/icons/dropdown-indicator.png"
            width  : 10
            height :  5
            anchors {
                right : parent.right
                rightMargin : 5
                verticalCenter : parent.verticalCenter
            }
            color : ma.pressed || popup.popupVisible ?
                    UI.color(UI.PrimaryBase) : UI.color(UI.DropdownIndicatorIcon)
        }
    }

    MouseArea {
        id : ma
        anchors.fill : parent
        hoverEnabled : true
        onClicked : openPopupAction.trigger()
    }

    DropdownButtonPopup {
        id : popup

        anchors.top : parent.bottom
        actions : dropdownButton.actions
        dropdownButton : dropdownButton
        activeIndex : dropdownButton.currentIndex

        onAccepted : {
            dropdownButton.actions[result].trigger();
            popup.hide();
        }
        onPopupVisibleChanged: popupVisible ? focus = true : focus = false
    }
}
